<?php
/* Copyright (C) 2007-2008 Jeremie Ollivier    <jeremie.o@laposte.net>
 * Copyright (C) 2011      Laurent Destailleur <eldy@users.sourceforge.net>
 * Copyright (C) 2012      Marcos García       <marcosgdf@gmail.com>
 * Copyright (C) 2018      Andreu Bisquerra    <jove@bisquerra.com>
 * Copyright (C) 2019      Josep Lluís Amador  <joseplluis@lliuretic.cat>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

/**
 *	\file       htdocs/takepos/floors.php
 *	\ingroup    takepos
 *	\brief      Page to show a receipt.
 */

if (!isset($action)) require '../main.inc.php'; // If this file is called from send.php avoid load again
include_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
include_once DOL_DOCUMENT_ROOT.'/takepos/class/contador.class.php';

$langs->loadLangs(array("main", "cashdesk", "companies"));

$place = (GETPOST('place', 'aZ09') ? GETPOST('place', 'aZ09') : 0); // $place is id of table for Ba or Restaurant
$facid = GETPOST('facid', 'int');

if (empty($user->rights->takepos->run)) {
	accessforbidden();
}


/*
 * View
 */

top_httphead('text/html');

if ($place > 0)
{
    $sql = "SELECT rowid FROM ".MAIN_DB_PREFIX."facture where ref='(PROV-POS".$_SESSION["takeposterminal"]."-".$place.")'";
    $resql = $db->query($sql);
    $obj = $db->fetch_object($resql);
    if ($obj)
    {
        $facid = $obj->rowid;
    }
}
$object = new Facture($db);
$object->fetch($facid);
$objectContador= new Contador($db);
// Call to external receipt modules if exist
$hookmanager->initHooks(array('takeposfrontend'), $facid);
$reshook = $hookmanager->executeHooks('TakeposReceipt', $parameters, $object);
if (!empty($hookmanager->resPrint)) {
    print $hookmanager->resPrint;
	exit;
}

// IMPORTANT: This file is sended to 'Takepos Printing' application. Keep basic file. No external files as css, js... If you need images use absolute path.
?>
<html>
<body>
<style>
.right {
    text-align: right;
}
.center {
    text-align: center;
}
.left {
    text-align: left;
}
.p {line-height: 50%;padding: 0px;}
</style>
<center>
<font size="4">
<?php 
echo '<h5>COMPROBANTE DE INFORME DIARIO</h5>';
 echo '<p>'.$mysoc->name."<br>"; 
 print $langs->trans("NIT").': '.$conf->global->MAIN_INFO_SIRET."<br>"; 
 print $conf->global->MAIN_INFO_SOCIETE_FORME_JURIDIQUE;"</p>";

date_default_timezone_set('America/Bogota');
$fecha= date("d-m-Y H:i:s")  ;
#$fecha= "05-11-2020 16:46:41"  ;
#$fechaconsulta="2020-11-05" //ejemplo de generacion reporte fechas anteriores 
$fechaconsulta=date("Y-m-d")  ?>
</font>
</center>
<!--<p class="left">-->
<?php
/*if (!empty($conf->global->TAKEPOS_HEADER))
{
	$substitutionarray = getCommonSubstitutionArray($langs);
	if (!empty($conf->global->TAKEPOS_HEADER))
	$newfreetext = make_substitutions($conf->global->TAKEPOS_HEADER, $substitutionarray);
	echo $newfreetext;
}*/
?>
<!--</p> 
<p class="right">-->
<?php

/*if (!empty($conf->global->TAKEPOS_RECEIPT_NAME)) print $conf->global->TAKEPOS_RECEIPT_NAME." ";
if ($object->statut == Facture::STATUS_DRAFT) print str_replace(")", "", str_replace("-", " ".$langs->trans('Place')." ", str_replace("(PROV-POS", $langs->trans("Terminal")." ", $object->ref)));
else print $object->ref;
if ($conf->global->TAKEPOS_SHOW_CUSTOMER)
{
	if ($object->socid != $conf->global->{'CASHDESK_ID_THIRDPARTY'.$_SESSION["takeposterminal"]})
	{
		$soc = new Societe($db);
		if ($object->socid > 0) $soc->fetch($object->socid);
		else $soc->fetch($conf->global->{'CASHDESK_ID_THIRDPARTY'.$_SESSION["takeposterminal"]});
		print "<br>".$langs->trans("Customer").': '.$soc->name;
		print "<br>".$langs->trans("NIT").': '.$conf->global->MAIN_INFO_SOCIETE_ZIP;
                
	}
}*/
?>
<!--</p>-->
    <?php
    $sql=" select  COUNT(rowid)cantidadf, sum(tva)tva,sum(total)total, sum(total_ttc)total_ttc from ";
    $sql.= MAIN_DB_PREFIX."facture  ";
    $sql.=" WHERE module_source='takepos' and datef='".$fechaconsulta."'";     //curdate() ";
    $sql.=" and entity IN( $conf->entity)";
    $sql.=" GROUP by fk_mode_reglement ";
    $resql = $db->query($sql);//echo $sql;exit;
    if($resql){   
        $num=$db->num_rows($resql);
        if($num >0){
            $totaliva=0;
            $totalsinIva=0;
            $totalconIva=0;
            $contador = $objectContador->getContador($conf->entity) ; 
          ?>
       <h3><?php print "Fecha: ".$fecha?><?php echo "  Z  #".$contador?></h3>
        <table width="100%" style="border-top-style: double;">
        <thead>
	<tr>
        <th class="left" width="15%"><?php print $langs->trans("Cant. Fac."); ?></th>
        <th class="left"><?php print $langs->trans("Total SIN IVA"); ?></th>
        <th class="center"><?php print $langs->trans("Total IVA"); ?></th>
        <th class="right"><?php print $langs->trans("TotalTTC"); ?></th>
	</tr>
      </thead>
       <tbody>     
         <?php 
        for($i=0;$i<$num;$i++){
            $obj=$db->fetch_object($resql);
            $totaliva+=$obj->tva;
            $totalsinIva+=$obj->total;
            $totalconIva+=$obj->total_ttc;
            ?>
        <tr>
            <td class="left" width="14%"><?php echo$obj->cantidadf; ?></td>
            <td class="left"  width="27%"><?php echo price($obj->total); ?></td>
            <td class="center"  width="27%"><?php echo price($obj->tva); ?></td>
            <td class="right"  width="27%"><?php echo price($obj->total_ttc); ?></td>
        </tr>
        
        <?php
        }
        }else{
            echo'<tr><td colspan="4">No hay Ventas para'. $fechaconsulta.' </td></tr>';
        }
    }else{
        dol_print_error($db);
    }
    ?>
    </tbody>
</table>
<br>
<table class="right">
<tr><th class="right"><?php echo $langs->trans("Total"); ?></th>
<td class="right"><?php echo price($totalsinIva, 1, '', 1, - 1, - 1, $conf->currency)."\n"; ?></td>
</tr>
<tr>
	<th class="right"><?php echo $langs->trans("TotalVAT").'</th><td class="right">'.price($totaliva, 1, '', 1, - 1, - 1, $conf->currency)."\n"; ?></td>
</tr>
<tr>
	<th class="right"><?php echo ''.$langs->trans("TotalTTC").'</th><td class="right">'.price($totalconIva, 1, '', 1, - 1, - 1, $conf->currency)."\n"; ?></td>
</tr>
</table>
<div style="border-top-style: double;"></div>
<h6>
<?php echo " Factura Inicial ". $objectContador->getFacturaInicial($conf->entity, $fechaconsulta) . " Factura Final ". $objectContador->getFacturaFinal($conf->entity, $fechaconsulta)  ?>
</h6>
<?php
/*if (!empty($conf->global->TAKEPOS_FOOTER))
{
	$substitutionarray = getCommonSubstitutionArray($langs);
	$newfreetext = make_substitutions($conf->global->TAKEPOS_FOOTER, $substitutionarray);
	echo $newfreetext;
}*/
?>

<script type="text/javascript">
    window.print();
</script>
</body>
</html>
